// Funções principais

function toggleAdult() {
    const current = localStorage.getItem(ADULT_FILTER_KEY) === 'true';
    localStorage.setItem(ADULT_FILTER_KEY, (!current).toString());
    updateAdultButton();
    window.location.reload();
}

function updateAdultButton() {
    const btn = document.getElementById('btnAdult');
    const showAdult = localStorage.getItem(ADULT_FILTER_KEY) === 'true';
    btn.textContent = showAdult ? '+18' : 'MOSTRAR +18';
    if(showAdult) btn.classList.add('active'); else btn.classList.remove('active');
}

function openSearch() {
    document.getElementById('searchModal').classList.add('active');
    document.getElementById('searchInput').focus();
}

function closeSearch() {
    document.getElementById('searchModal').classList.remove('active');
}

function searchContent(event) {
    event.preventDefault();
    const query = document.getElementById('searchInput').value;
    if (!query) return;
    closeSearch();
    window.location.href = `search.html?q=${encodeURIComponent(query)}`;
}

function createCard(item, type) {
    const title = item.title || item.name;
    const poster = item.poster_path ? `${TMDB_IMAGE_BASE}${item.poster_path}` : 'https://via.placeholder.com/300x450/1a1a1a/2196F3?text=Sem+Imagem';
    const itemType = type || item.media_type || (item.title ? 'movie' : 'tv');
    const genres = item.genre_ids ? item.genre_ids.map(id => movieGenres[id] || tvGenres[id]).filter(Boolean).slice(0,2).join(', ') : 'Geral';
    return `<div class="card" onclick="window.location.href='detail.html?type=${itemType}&id=${item.id}'"><div class="card-img"><img src="${poster}" alt="${title}" loading="lazy"><div class="card-overlay"><div class="play-btn"><i class="fas fa-play"></i></div></div></div><div class="card-body"><h3 class="card-title">${title}</h3><span class="badge-type">${itemType === 'movie' ? 'Filme' : 'Episódio'} - ${genres}</span></div></div>`;
}

async function loadPopularContent() {
    const grid = document.getElementById('contentGrid');
    const loading = document.getElementById('loadingContent');
    loading.style.display = 'block';
    grid.innerHTML = '';
    try {
        const [movies, series] = await Promise.all([getPopularMovies(), getPopularSeries()]);
        const combined = [...movies.slice(0, 10), ...series.slice(0, 10)];
        combined.forEach(item => grid.innerHTML += createCard(item));
    } catch (error) {
        grid.innerHTML = '<p style="text-align:center;color:#666">Erro ao carregar.</p>';
    } finally {
        loading.style.display = 'none';
    }
}

async function loadMovies() {
    const grid = document.getElementById('contentGrid');
    const loading = document.getElementById('loadingContent');
    loading.style.display = 'block';
    grid.innerHTML = '';
    try {
        const movies = await getPopularMovies();
        movies.forEach(movie => grid.innerHTML += createCard(movie, 'movie'));
    } catch (error) {
        grid.innerHTML = '<p style="text-align:center;color:#666">Erro.</p>';
    } finally {
        loading.style.display = 'none';
    }
}

async function loadSeries() {
    const grid = document.getElementById('contentGrid');
    const loading = document.getElementById('loadingContent');
    loading.style.display = 'block';
    grid.innerHTML = '';
    try {
        const series = await getPopularSeries();
        series.forEach(serie => grid.innerHTML += createCard(serie, 'tv'));
    } catch (error) {
        grid.innerHTML = '<p style="text-align:center;color:#666">Erro.</p>';
    } finally {
        loading.style.display = 'none';
    }
}

document.addEventListener('keydown', e => { if (e.key === 'Escape') closeSearch(); });
